// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.verb;

import ORG.oclc.oai.util.OAIUtil;
import java.util.Map;
import org.xml.sax.Attributes;
import java.util.Iterator;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.InputSource;
import java.io.StringReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xml.sax.XMLReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.xml.sax.helpers.DefaultHandler;

public class Record extends DefaultHandler
{
    private static final boolean debug = false;
    private static HashMap xmlReaders;
    private String record;
    private boolean identifierCapture;
    private StringBuffer identifier;
    private boolean datestampCapture;
    private StringBuffer datestamp;
    private boolean setSpecCapture;
    private ArrayList setSpecs;
    private StringBuffer setSpec;
    private String status;
    private boolean metadataCapture;
    private StringBuffer metadata;
    private boolean aboutCapture;
    private ArrayList abouts;
    private StringBuffer about;
    private HashMap xmlnsMap;
    
    private XMLReader getXMLReader() throws SAXException {
        final Thread currentThread = Thread.currentThread();
        XMLReader xmlReader = Record.xmlReaders.get(currentThread);
        if (xmlReader == null) {
            try {
                xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException e) {
                try {
                    xmlReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (SAXException e2) {
                    try {
                        xmlReader = XMLReaderFactory.createXMLReader("com.bluecase.xml.Piccolo");
                    }
                    catch (SAXException e3) {
                        try {
                            xmlReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                        }
                        catch (SAXException e4) {
                            try {
                                xmlReader = XMLReaderFactory.createXMLReader();
                            }
                            catch (SAXException e5) {
                                throw new SAXException("No SAX parser available");
                            }
                        }
                    }
                }
            }
            Record.xmlReaders.put(currentThread, xmlReader);
        }
        return xmlReader;
    }
    
    public Record(final String record) throws SAXException, IOException {
        this.record = null;
        this.identifierCapture = false;
        this.identifier = new StringBuffer();
        this.datestampCapture = false;
        this.datestamp = new StringBuffer();
        this.setSpecCapture = false;
        this.setSpecs = new ArrayList();
        this.status = null;
        this.metadataCapture = false;
        this.metadata = new StringBuffer();
        this.aboutCapture = false;
        this.abouts = new ArrayList();
        this.about = new StringBuffer();
        this.xmlnsMap = new HashMap();
        this.record = record;
        final XMLReader xmlReader = this.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(new StringReader(record)));
        }
        catch (SAXException e) {
            System.out.println("Record.Record: record=" + record);
            e.printStackTrace();
            throw e;
        }
    }
    
    public String getRecordXML() {
        return this.record;
    }
    
    public boolean isDeleted() {
        return "deleted".equals(this.status);
    }
    
    public String getIdentifier() {
        return this.identifier.toString();
    }
    
    public String getDatestamp() {
        return this.datestamp.toString();
    }
    
    public Iterator getSetSpecs() {
        if (this.setSpecs.size() > 0) {
            return this.setSpecs.iterator();
        }
        return null;
    }
    
    public String getMetadata() {
        if (this.metadata.length() > 0) {
            return this.metadata.toString();
        }
        return null;
    }
    
    public Iterator getAbouts() {
        if (this.about.length() > 0) {
            return this.abouts.iterator();
        }
        return null;
    }
    
    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("Record.identifier=");
        sb.append(this.getIdentifier());
        sb.append("\nRecord.datestamp=");
        sb.append(this.getDatestamp());
        final Iterator setSpecs = this.getSetSpecs();
        if (setSpecs != null) {
            while (setSpecs.hasNext()) {
                sb.append("\nRecord.setSpec=");
                sb.append(setSpecs.next());
            }
        }
        sb.append("\nRecord.status=");
        sb.append(this.status);
        sb.append("\nRecord.metadata=");
        sb.append(this.getMetadata());
        final Iterator abouts = this.getAbouts();
        if (abouts != null) {
            while (abouts.hasNext()) {
                sb.append("\nRecord.about=");
                sb.append(abouts.next());
            }
        }
        sb.append("\n");
        return sb.toString();
    }
    
    public void startElement(final String namespaceURI, final String localName, final String qName, final Attributes attrs) {
        final String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        final int length = attrs.getLength();
        if (!this.metadataCapture && fullName.equals("#metadata")) {
            this.metadata.setLength(0);
            this.metadataCapture = true;
            this.addXmlns(attrs, this.xmlnsMap);
        }
        else if (!this.metadataCapture && !this.aboutCapture && fullName.equals("#about")) {
            this.about.setLength(0);
            this.aboutCapture = true;
            this.addXmlns(attrs, this.xmlnsMap);
        }
        else if (this.metadataCapture) {
            this.metadata.append("<");
            this.metadata.append(qName);
            final HashMap tempMap = new HashMap();
            tempMap.putAll(this.xmlnsMap);
            for (int i = 0; i < length; ++i) {
                this.metadata.append(" ");
                final String aEName = attrs.getQName(i);
                this.metadata.append(aEName);
                this.metadata.append("=\"");
                this.metadata.append(OAIUtil.xmlEncode(attrs.getValue(i)));
                this.metadata.append("\"");
                tempMap.remove(aEName);
            }
            for (final Map.Entry entry : tempMap.entrySet()) {
                final String aEName2 = entry.getKey();
                this.metadata.append(" ").append(aEName2).append("=\"").append(entry.getValue()).append("\"");
            }
            this.metadata.append(">");
        }
        else if (this.aboutCapture) {
            this.about.append("<");
            this.about.append(qName);
            final HashMap tempMap = new HashMap();
            tempMap.putAll(this.xmlnsMap);
            for (int i = 0; i < length; ++i) {
                this.about.append(" ");
                final String aEName = attrs.getQName(i);
                this.about.append(aEName);
                this.about.append("=\"");
                this.about.append(OAIUtil.xmlEncode(attrs.getValue(i)));
                this.about.append("\"");
                tempMap.remove(aEName);
            }
            for (final Map.Entry entry : tempMap.entrySet()) {
                final String aEName2 = entry.getKey();
                this.about.append(" ").append(aEName2).append("=\"").append(entry.getValue()).append("\"");
            }
            this.about.append(">");
        }
        else if (fullName.equals("#identifier")) {
            this.identifierCapture = true;
        }
        else if (fullName.equals("#datestamp")) {
            this.datestampCapture = true;
        }
        else if (fullName.equals("#setSpec")) {
            this.setSpecCapture = true;
            this.setSpec = new StringBuffer();
        }
        else if (fullName.equals("#record")) {
            this.addXmlns(attrs, this.xmlnsMap);
        }
        else if (fullName.equals("#header")) {
            for (int j = 0; j < length; ++j) {
                final String aEName3 = HarvesterVerb.fullName(attrs.getURI(j), attrs.getLocalName(j));
                if (HarvesterVerb.OAI20_STATUS.equals(aEName3)) {
                    this.status = attrs.getValue(j);
                }
            }
        }
        else {
            System.out.println("Unrecognized element: " + qName);
        }
    }
    
    private void addXmlns(final Attributes attrs, final HashMap xmlnsMap) {
        for (int length = attrs.getLength(), i = 0; i < length; ++i) {
            final String aEName = attrs.getQName(i);
            if (aEName.startsWith("xmlns:")) {
                xmlnsMap.put(aEName, attrs.getValue(i));
            }
        }
    }
    
    public void endElement(final String namespaceURI, final String localName, final String qName) throws SAXException {
        final String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (fullName.equals("#metadata")) {
            this.metadataCapture = false;
        }
        else if (fullName.equals("#about")) {
            this.aboutCapture = false;
        }
        if (this.metadataCapture) {
            this.metadata.append("</");
            this.metadata.append(qName);
            this.metadata.append(">");
        }
        else if (this.aboutCapture) {
            this.about.append("</");
            this.about.append(qName);
            this.about.append(">");
        }
        else if (!this.identifierCapture) {
            if (!this.datestampCapture) {
                if (this.setSpecCapture) {}
            }
        }
        if (fullName.equals("#about")) {
            this.aboutCapture = false;
            this.abouts.add(this.about.toString());
        }
        else if (fullName.equals("#identifier")) {
            this.identifierCapture = false;
        }
        else if (fullName.equals("#datestamp")) {
            this.datestampCapture = false;
        }
        else if (fullName.equals("#setSpec")) {
            this.setSpecs.add(this.setSpec.toString());
            this.setSpecCapture = false;
        }
    }
    
    public void characters(final char[] buf, final int offset, final int len) {
        final String s = new String(buf, offset, len);
        if (this.identifierCapture) {
            this.identifier.append(OAIUtil.xmlEncode(s));
        }
        else if (this.datestampCapture) {
            this.datestamp.append(OAIUtil.xmlEncode(s));
        }
        else if (this.setSpecCapture) {
            this.setSpec.append(OAIUtil.xmlEncode(s));
        }
        else if (this.metadataCapture) {
            this.metadata.append(OAIUtil.xmlEncode(s));
        }
        else if (this.aboutCapture) {
            this.about.append(OAIUtil.xmlEncode(s));
        }
        else if (s.trim().length() > 0) {
            System.out.println("Unrecognized content:" + s);
        }
    }
    
    static {
        Record.xmlReaders = new HashMap();
    }
}
